class Calculator {
  constructor() {
    this.allCalBtn = document.querySelectorAll('.calculator-btn');
    this.allCalActBtn = document.querySelectorAll('.calculator-act-btn');
    this.allCalNumBtn = document.querySelectorAll('.cal-print-btn');
    this.displayAns = document.querySelector('#calculator-ans');
    this.allOperatorBtn = document.querySelectorAll('.calculator-operator');
    this.displayError = document.querySelector('#diplay-error');
    this.calculateBtn = document.querySelector('#calculator-act-btn-equals');
    this.calBackBtn = document.querySelector('#diplay-error button')

    this.previousAns = (() => {
      const match = document.cookie.match(/(^|;) ?previousAns=([^;]*)/);
      return match ? match[2] : undefined;
    })();

    this.delbtn = document.querySelector('#calculator-act-btn-del');
    this.acbtn = document.querySelector('#calculator-act-btn-ac');

    this.operator_NumFinder();
    this.operation();
    this.eventListener();
  }

  operator_NumFinder() {
    this.allCalNumBtn.forEach((btn) => {
      btn.addEventListener('click', () => {
        this.num = btn.innerText;
        this.printer(this.num);
      });
    });
  }

  calculator() {
    let question = this.displayAns.value;
    let num = question.toLowerCase().split(/(ans|[+\-×÷])/);

    try {
      for (let i = 0; i < num.length; i++) {
        if (num[i] === 'ans') {
          if (this.previousAns !== undefined) {
            num[i] = this.previousAns;
          } else {
            throw new Error('No previous answer found');
          }
        }
      }

      let expression = num.map(el => {
        if (el === '×') return '*';
        if (el === '÷') return '/';
        return el;
      }).join('');
      
      let result = math.evaluate(expression);
      this.showAns(result);
      this.previousAns = result;
      document.cookie = `previousAns=${result}; path=/;`;
    } catch (e) {
      this.displayerror(e.message);
    }
  }

  showAns(result) {
    this.displayAns.value = 'Calculating';
    setTimeout(() => {
      this.displayAns.value = result;
    }, 400);
  }

  printer(num) {
    this.displayAns.value += num;
  }

  eventListener() {
    this.calculateBtn.addEventListener('click', () => {
      this.calculator();
    });

    document.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') {
        this.calculator();
      }
    });


    this.delbtn.addEventListener('click', () => {
      this.displayAns.value = this.displayAns.value.slice(0, -1);
    });

    this.acbtn.addEventListener('click', () => {
      this.displayAns.value = '';
    });
  }

  displayerror(type) {
    this.displayAns.classList.add('hidden');
    this.displayError.classList.remove('hidden');

    this.displayError.innerHTML = '';
    let errorElement = document.createElement('p');
    errorElement.innerText = type;
    this.displayError.appendChild(errorElement);

    let backBtn = document.createElement('button');
    backBtn.innerText = 'Back';
    backBtn.addEventListener('click', () => {
      this.displayAns.classList.remove('hidden');
      this.displayError.classList.add('hidden');
    });
    this.displayError.appendChild(backBtn);
  }


  displaySwicher(yesno) {
    if (yesno) {
      this.displayAns.value = 'Calculating';
      setTimeout(() => {
        this.displayAns.classList.add('hidden');
        this.displayError.classList.remove('hidden');
      }, 400);
    } else {
      this.displayAns.classList.remove('hidden');
      this.displayError.classList.add('hidden');
    }
  }


  operation() {
    this.displayAns.addEventListener('keydown', (e) => {
      if (
        !(
          (e.key >= '0' && e.key <= '9') ||
          e.key === 'Backspace' ||
          e.key === 'Delete' ||
          e.key === 'ArrowLeft' ||
          e.key === 'ArrowRight' ||
          e.key === 'Enter' ||
          ['+', '-', '*', '/', '×', '÷'].includes(e.key)
        )
      ) {
        e.preventDefault();
      }
    });
  }
}

document.addEventListener('DOMContentLoaded', () => {
  new Calculator();
});