//Advance JavaScript
//cookie, sessions
let cookie = document.cookie; //this is a special cookie property in JavaScript
cookie = "name=John Doe; expires=Thu, 18 Dec 2026 12:00:00 UTC; path=/"; //by doing this we are not rewriting the whole thing under document.cookie this is the special thing about document.cookie we are just appending to it
console.log(cookie);

//Let's learn cookies by crationg a to do list
let toDoListBtn = document.querySelector("#add-item-btn");
let ToDoTable = document.querySelector("#ToDo-table")
let clearBtn = document.querySelector("#ToDo-clear");
const addItemBtn = document.getElementById('add-item-submit');
let errorMessage = document.querySelector(".error")
let counter = Number(localStorage.getItem('toDoCounter')) || 0;
let closeBtn = document.querySelectorAll(".close-btn");
let clearAllBtn = document.querySelector("#clear-all");

class Popup {
  constructor(popupSelector, overlaySelector) {
    const popups = document.querySelectorAll(popupSelector);
    this.popups = Array.from(popups);
    this.overlay = document.querySelector(overlaySelector);
  }

  start() {
    if (this.popups.length) {
      this.popups.forEach((popup) => {
        popup.classList.remove("opacity-0");
        popup.classList.add("opacity-100", "shown");
      });
    }
    if (this.overlay) {
      this.overlay.classList.remove("opacity-0", "hidden");
      this.overlay.classList.add("opacity-100", "overlayShown");
    }
  }

  stop() {
    if (this.popups.length) {
      this.popups.forEach((popup) => {
        popup.classList.add("opacity-0");
        popup.classList.remove("opacity-100", "shown");
      });
    }
    if (this.overlay) {
      this.overlay.classList.add("opacity-0", "hidden");
      this.overlay.classList.remove("opacity-100", "overlayShown");
    }
  }
}

const popupCloseFunction = (elements, popupSelector = ".popup, .popup-confirmation") => {
  const items = elements instanceof Element ? [elements] : Array.from(elements || []);
  items.forEach((btn) => {
    btn.addEventListener("click", () => {
      let myPopup = new Popup(popupSelector, ".full-overlay");
      myPopup.stop();
    });
  });
};

const HTMLMaker = (HTML, itemKey) => {
  const tr = document.createElement('tr');
  tr.innerHTML = HTML;
  const td = document.createElement('td');
  const btn = document.createElement('button');
  btn.className = 'btn-lite delete-btn';
  btn.dataset.key = itemKey;
  btn.textContent = 'Delete This';
  btn.addEventListener("click", () => {
    const itemKeyLocal = btn.dataset.key;
    localStorage.removeItem(itemKeyLocal);
    btn.closest("tr").remove();
    const anyItems = Object.keys(localStorage).some(k => /\s\d+$/.test(k));
    if (!anyItems) ToDoTable.classList.add("hidden");
  });
  td.appendChild(btn);
  tr.appendChild(td);

  const table = document.querySelector('#ToDo-table');
  if (table) {
    table.appendChild(tr);
  } else {
    const newTable = document.createElement('table');
    newTable.appendChild(tr);
    document.body.appendChild(newTable);
  }
};

if (localStorage.getItem('toDoCounter') !== null) {
  ToDoTable.classList.remove("hidden");
}
if (!document.getElementById("there-is-table")) {
  ToDoTable.classList.add("hidden");
}

for (let i = 1; i <= counter; i++) {
  const key = Object.keys(localStorage).find(k => k.endsWith(` ${i}`));
  if (!key) continue;

  const storedItem = JSON.parse(localStorage.getItem(key));
  if (!storedItem) continue;

  const name = storedItem.name;
  const date = storedItem.date;
  const status = storedItem.status;
  const priority = storedItem.priority;
  const note = storedItem.note;

  const HTML = `
    <td>${name}</td>
    <td>${date}</td>
    <td>${status}</td>
    <td>${priority}</td>
    <td>${note}</td>
  `;
  HTMLMaker(HTML, key);
}

addItemBtn.addEventListener('click', () => {
  const itemName = document.getElementById('ToDo-name').value.trim();
  const itemDate = document.getElementById('ToDo-date').value.trim();
  const itemStatus = document.getElementById('ToDo-status').value.trim();
  const itemPriority = document.getElementById('ToDo-priority').value.trim();
  const itemNote = document.getElementById('ToDo-note').value.trim();
  if (itemName && itemDate && itemStatus && itemPriority && itemNote) {
    counter++;
    const key = `${itemName} ${counter}`;

    let itemValue = {
      name: itemName,
      date: itemDate,
      status: itemStatus,
      priority: itemPriority,
      note: itemNote
    };
    localStorage.setItem(key, JSON.stringify(itemValue));
    localStorage.setItem('toDoCounter', counter);

    const HTML = `
      <td>${itemName}</td>
      <td>${itemDate}</td>
      <td>${itemStatus}</td>
      <td>${itemPriority}</td>
      <td>${itemNote}</td>
    `;
    HTMLMaker(HTML, key);
    ToDoTable.classList.remove("hidden");

    let addPopup = new Popup(".popup:not(.popup-confirmation)", ".full-overlay");
    addPopup.stop();
  } else {
    errorMessage.textContent = "Please fill in All fields";
  }
});

clearBtn.addEventListener("click", () => {
  localStorage.clear();
  location.reload();
});

popupCloseFunction(closeBtn);

clearAllBtn.addEventListener("click", () => {
  let myPopup = new Popup("#clear-all-popup", ".full-overlay");
  myPopup.start();
});

toDoListBtn.addEventListener("click", () => {
  let myPopup = new Popup(".popup:not(.popup-confirmation)", ".full-overlay");
  myPopup.start();
});
