<?php
include_once 'site-parts/functions.php';

// Enqueue CSS/JS
enqueue_file('style/login.css', 'css', 'header');
enqueue_file('script/login.js', 'js', 'footer');
page_title('Login');

// Redirect if already logged in via session or cookie
if (
    (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) ||
    (isset($_COOKIE['logged_in']) && $_COOKIE['logged_in'] === 'true')
) {
    header("Location: index.php");
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = mysqli_real_escape_string($conn, trim($_POST['username']));
    $password = mysqli_real_escape_string($conn, trim($_POST['password']));

    $sql = "SELECT * FROM users WHERE username = '$username' OR email = '$username' LIMIT 1";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $user = mysqli_fetch_assoc($result);

        if (password_verify($password, $user['password'])) {
            // Set session
            $_SESSION['logged_in'] = true;
            $_SESSION['username'] = $user['username'];
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['fast_name'] = explode(' ', trim($user['full_name']))[0];

            // Set cookies for 30 days if "remember me" is checked
            if (isset($_POST['remember_30_days'])) {
                $expire = time() + 30 * 24 * 60 * 60; // 30 days
                setcookie('logged_in', 'true', $expire, '/');
                setcookie('username', $user['username'], $expire, '/');
                setcookie('full_name', $user['full_name'], $expire, '/');
                setcookie('fast_name', explode(' ', trim($user['full_name']))[0], $expire, '/');
            }

            header("Location: index.php");
            exit;
        } else {
            $_SESSION['flash_message'] = "Username or Password do not match.";
            header("Location: login.php");
            exit;
        }
    } else {
        $_SESSION['flash_message'] = "Username or Password do not match.";
        header("Location: login.php");
        exit;
    }
}

// Display flash message if exists
$message = '';
if (isset($_SESSION['flash_message'])) {
    $msgText = $_SESSION['flash_message'];
    $message = '<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256" viewBox="0 0 256 256">
        <g transform="translate(1.4 1.4) scale(2.81 2.81)">
            <path d="M11 90c-2.815 0-5.63-1.074-7.778-3.222c-4.295-4.296-4.295-11.261 0-15.557l68-68c4.297-4.296 11.26-4.296 15.557 0c4.296 4.296 4.296 11.261 0 15.557l-68 68C16.63 88.926 13.815 90 11 90z" fill="rgb(214,0,0)"/>
            <path d="M79 90c-2.815 0-5.63-1.074-7.778-3.222l-68-68c-4.295-4.296-4.295-11.261 0-15.557c4.296-4.296 11.261-4.296 15.557 0l68 68c4.296 4.296 4.296 11.261 0 15.557C84.63 88.926 81.815 90 79 90z" fill="rgb(214,0,0)"/>
        </g>
    </svg><p class="l-c-red">' . $msgText . '</p>';
    unset($_SESSION['flash_message']); // Clear after showing
}


require_once 'site-parts\head.php';
?>


<main>


    <div class="div-little margin-bottom50">
        <h1 class="l-c-white">Login</h1>
        <img src="files\images\login-LOGO.png" alt="A logo of PHP" class="main-image" />
    </div>

    <div class="div-parent-style-simple margin-bottom50">
        <div
            class="div-child-style-simple l-div-column padding-50"
            id="login-div-child">

            <form method="POST">

                <label
                    for="username"
                    class="label-s-2">
                    Your Username
                </label>
                <input
                    type="text"
                    class="l-widh90 input-s-1"
                    name="username" required
                    placeholder="E.g., devid121"
                    required />

                <label
                    for="password"
                    class="label-s-2">
                    Password
                </label>
                <input
                    type="password"
                    class="l-widh90 no-copy input-s-1"
                    id="user-password"
                    name="password"
                    placeholder="Password"
                    required
                    required />
                <div class="div-row div-align-center" id="remember_30_days">
                    <input type="checkbox" name="remember_30_days" id="remember_30_days" />
                    <label for="remember_30_days">Remember me for 30 days</label>
                </div>

                <div id="show-password">
                    <button id="show-password-button" type="button"></button>
                    <p>Show Password</p>
                </div>
                <p id="password-message"></p>
                <input
                    type="submit"
                    class="btn padding-top-10 margin-top10 user-passowrd"
                    value="login" />
            </form>
            <p class="l-t-align-center l-padding-top-10">Don't have an account?
                <a href="http://localhost/fast-app/register.php">Register</a>
            </p>
        </div>
    </div>
    <div class="error-popup hidden">

        <?php echo $massage; ?>

        <button class="btn2" id="close-popup">Okay</button>
    </div>
</main>

<?php
include 'site-parts\footer.php';

//Here we are closing everything up so nothing stays open and slows down our application 
mysqli_close($conn);
?>