<?php
include_once 'site-parts\functions.php';
enqueue_file('style\login.css', 'css', 'header');
enqueue_file('script\login.js', 'js', 'footer');
page_title('Sign Up');
if (
    (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) ||
    (isset($_COOKIE['logged_in']) && $_COOKIE['logged_in'] === 'true')
) {
    header("Location: index.php");
}
$error = '';
$massage = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = mysqli_real_escape_string(
        $conn,
        htmlspecialchars(trim($_POST['full_name']))
    );
    $username = mysqli_real_escape_string(
        $conn,
        htmlspecialchars(trim($_POST['username']))
    );
    $User_Email = mysqli_real_escape_string(
        $conn,
        htmlspecialchars(trim($_POST['email']))
    );
    $User_role = mysqli_real_escape_string(
        $conn,
        htmlspecialchars(trim($_POST['role']))
    );
    $User_Password = mysqli_real_escape_string(
        $conn,
        htmlspecialchars(trim($_POST['password']))
    );
    $User_Confirm_Password = mysqli_real_escape_string(
        $conn,
        htmlspecialchars(trim($_POST['confirm_password']))
    );

    if ($User_Password === $User_Confirm_Password) {
        $sql = "SELECT * FROM users WHERE email='$User_Email' LIMIT 1";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            $error .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve">
            <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
              <path d="M 11 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 c -4.295 -4.296 -4.295 -11.261 0 -15.557 l 68 -68 c 4.297 -4.296 11.26 -4.296 15.557 0 c 4.296 4.296 4.296 11.261 0 15.557 l -68 68 C 16.63 88.926 13.815 90 11 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
             <path d="M 79 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 l -68 -68 c -4.295 -4.296 -4.295 -11.261 0 -15.557 c 4.296 -4.296 11.261 -4.296 15.557 0 l 68 68 c 4.296 4.296 4.296 11.261 0 15.557 C 84.63 88.926 81.815 90 79 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
            </g></svg>' .
                "<p> Email already exists. Please Choose Another</p>";

            echo "<script>
       document.addEventListener('DOMContentLoaded', function() {
       messagePopup();
       });
       </script>";
        } else {
            if (user_exists($conn, $username)) {
                $error .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve">
                       <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
 	                    <path d="M 11 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 c -4.295 -4.296 -4.295 -11.261 0 -15.557 l 68 -68 c 4.297 -4.296 11.26 -4.296 15.557 0 c 4.296 4.296 4.296 11.261 0 15.557 l -68 68 C 16.63 88.926 13.815 90 11 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
	                    <path d="M 79 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 l -68 -68 c -4.295 -4.296 -4.295 -11.261 0 -15.557 c 4.296 -4.296 11.261 -4.296 15.557 0 l 68 68 c 4.296 4.296 4.296 11.261 0 15.557 C 84.63 88.926 81.815 90 79 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                       </g></svg>' .
                    "<p> Username already exists. Please Choose Another</p>";

                echo "<script>
                  document.addEventListener('DOMContentLoaded', function() {
                  messagePopup();
                  });
                  </script>";
            } else {
                //Let's hash the password
                $password_hash = password_hash($User_Password, PASSWORD_DEFAULT);
                $insert_sql = "INSERT INTO `users` (`full_name`, `role`, `username`, `password`, `email`) 
                           VALUES ('$full_name', '$User_role', '$username', '$password_hash', '$User_Email')";
                if (mysqli_query($conn, $insert_sql)) {
                    $_SESSION['logged_in'] = true;
                    $_SESSION['username'] = $username;
                    $_SESSION['email'] = $User_Email;
                    $_SESSION['role'] = $User_role;
                    $_SESSION['full_name'] = $full_name;
                    $_SESSION['fast_name'] = explode(' ', trim($full_name))[0];


                    if (isset($_POST['remember_30_days'])) {
                        // Set cookies to remember the user for 30 days
                        setcookie('logged_in', 'true', time() + 30 * 24 * 60 * 60, "/");
                        setcookie('username', $user['username'], time() + 30 * 24 * 60 * 60, "/");
                        setcookie('email', $user['email'], time() + 30 * 24 * 60 * 60, "/");
                        setcookie('role', $user['role'], time() + 30 * 24 * 60 * 60, "/");
                        setcookie('full_name', $user['full_name'], time() + 30 * 24 * 60 * 60, "/");
                        setcookie('fast_name', explode(' ', trim($user['full_name']))[0], time() + 30 * 24 * 60 * 60, "/");
                    }
                    $massage = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve">
                            <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
	                         <path d="M 45 90 C 20.187 90 0 69.813 0 45 C 0 20.187 20.187 0 45 0 c 24.813 0 45 20.187 45 45 C 90 69.813 69.813 90 45 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(0,186,119); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
	                         <polygon points="35.86,69.67 17.5,51.31 26.66,42.15 35.86,51.34 63.34,23.87 72.5,33.03 " style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" transform="  matrix(1 0 0 1 0 0) "/>' .
                        '<p> User registered successfully. </p>';


                    echo "<script>
                      document.addEventListener('DOMContentLoaded', function() {
                      messagePopup();
                      });
                      </script>";
                    sleep(2);
                    header("Location: index.php");
                    exit;
                } else {
                    $error .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve">
                           <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
	                        <path d="M 11 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 c -4.295 -4.296 -4.295 -11.261 0 -15.557 l 68 -68 c 4.297 -4.296 11.26 -4.296 15.557 0 c 4.296 4.296 4.296 11.261 0 15.557 l -68 68 C 16.63 88.926 13.815 90 11 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                           	<path d="M 79 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 l -68 -68 c -4.295 -4.296 -4.295 -11.261 0 -15.557 c 4.296 -4.296 11.261 -4.296 15.557 0 l 68 68 c 4.296 4.296 4.296 11.261 0 15.557 C 84.63 88.926 81.815 90 79 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                           </g></svg>'
                        . '<p>' . "Error: " . mysqli_error($conn) . '</p>';
                    echo "<script>
                      document.addEventListener('DOMContentLoaded', function() {
                      messagePopup();
                      });
                      </script>";
                }
            }
        }
    } else {
        $error .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve">
                   <g style="stroke: none; stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: none; fill-rule: nonzero; opacity: 1;" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)">
	                <path d="M 11 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 c -4.295 -4.296 -4.295 -11.261 0 -15.557 l 68 -68 c 4.297 -4.296 11.26 -4.296 15.557 0 c 4.296 4.296 4.296 11.261 0 15.557 l -68 68 C 16.63 88.926 13.815 90 11 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
	                <path d="M 79 90 c -2.815 0 -5.63 -1.074 -7.778 -3.222 l -68 -68 c -4.295 -4.296 -4.295 -11.261 0 -15.557 c 4.296 -4.296 11.261 -4.296 15.557 0 l 68 68 c 4.296 4.296 4.296 11.261 0 15.557 C 84.63 88.926 81.815 90 79 90 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: rgb(214,0,0); fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"/>
                   </g></svg>' .
            "<p>Password does not match</p>";
        echo "<script>
              document.addEventListener('DOMContentLoaded', function() {
              messagePopup();
              });
              </script>";
    }
}

require_once 'site-parts\head.php';
?>

<main>


    <div class="div-little margin-bottom50">
        <h1 class="l-c-white">Create Your Account</h1>
        <img src="files\images\login-LOGO.png" alt="A logo of PHP" class="main-image" />
    </div>

    <div class="div-parent-style-simple margin-bottom50">
        <div
            class="div-child-style-simple l-div-column padding-50"
            id="login-div-child">

            <form method="POST">
                <label
                    for="full_name"
                    class="label-s-2">
                    Full Name
                </label>
                <input
                    type="text"
                    required
                    class="l-widh90 input-s-1"
                    name="full_name"
                    placeholder="E.g., devid hunter"
                    required />
                <label
                    for="username"
                    class="label-s-2">
                    Your Username
                </label>
                <input
                    type="text"
                    class="l-widh90 input-s-1"
                    name="username" required
                    placeholder="E.g., devid121"
                    required />


                <label
                    for="email"
                    class="label-s-2">
                    Email
                </label>
                <input
                    type="email"
                    class="l-widh90 input-s-1"
                    name="email" required
                    placeholder="E.g., devid121@gmail.com"
                    required />
                <label
                    for="role"
                    class="label-s-2">
                    Role
                </label>
                <select
                    class="l-widh90 input-s-1"
                    name="role"
                    required>
                    <option value="" disabled selected>E.g., Admin</option>
                    <option value="admin">Admin</option>
                    <option value="user">User</option>
                </select>


                <label
                    for="password"
                    class="label-s-2">
                    Password
                </label>
                <input
                    type="password"
                    class="l-widh90 no-copy input-s-1"
                    id="user-password"
                    name="password"
                    placeholder="Password"
                    required
                    required />


                <label
                    for="confirm_password"
                    class="label-s-2">
                    Confirm Password
                </label>
                <input
                    type="password"
                    class="l-widh90 no-copy user-password input-s-1 user-passowrd"
                    name="confirm_password"
                    required
                    id="user-confirm_password"
                    placeholder="Confirm Password"
                    required />
                <div class="div-row div-align-center" id="remember_30_days">
                    <input type="checkbox" name="remember_30_days" id="remember_30_days" />
                    <label for="remember_30_days">Remember me for 30 days</label>
                </div>
                <div id="show-password">
                    <button id="show-password-button" type="button"></button>
                    <p>Show Password</p>
                </div>

                <p id="password-message"></p>

                <input
                    type="submit"
                    class="btn padding-top-10 margin-top10 user-passowrd"
                    value="register" />
            </form>
            <p class="l-t-align-center l-padding-top-10">Alrady have an account?
                <a href="http://localhost/fast-app/login.php">Login</a>
            </p>
        </div>
    </div>
    <div class="error-popup hidden">

        <?php echo $error . $massage; ?>

        <button class="btn2" id="close-popup">Okay</button>
    </div>
</main>

<?php
include 'site-parts\footer.php';

//Here we are closing everything up so nothing stays open and slows down our application 
mysqli_close($conn);
?>