const password = document.querySelector("#user-password");
const show_password_toggle = document.querySelector("#show-password-button");

let password_visible = false;

show_password_toggle.addEventListener("click", () => {
  if (!password_visible) {
    show_password_toggle.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" fill="green" width="24" height="24" viewBox="0 0 1920 1920" stroke="green">
      <path d="M1827.701 303.065 698.835 1431.801 92.299 825.266 0 917.564 698.835 1616.4 1919.869 395.234z" fill-rule="evenodd"/>
    </svg>`;
    show_password_toggle.style.padding = "0px";
    password.setAttribute("type", "text");
    password_visible = true;
  } else {
    show_password_toggle.innerHTML = ``;
    show_password_toggle.style.padding = "10px";
    password.setAttribute("type", "password");
    password_visible = false;
  }
});

const passwordField = document.getElementsByClassName("no-copy");
Array.from(passwordField).forEach((element) => {
  element.addEventListener("copy", (e) => {
    e.preventDefault();
  });
});

const error_popup_div = document.querySelector(".error-popup");
const close_popup_btn = document.querySelector("#close-popup");

const massagePopup = () => {
  error_popup_div.classList.remove("hidden");
  error_popup_div.classList.add("fade-in");
  error_popup_div.addEventListener(
    "animationend",
    () => {
      error_popup_div.classList.remove("fade-in");
    },
    { once: true }
  );
};

close_popup_btn.addEventListener("click", () => {
  error_popup_div.classList.add("hidden");
});
