const password = document.querySelector("#user-password");
const confirmPassword = document.querySelector("#user-confirm_password");
const message = document.querySelector("#password-message");

const checkPasswords = () => {
  const user_password = password.value;
  const confirm_password = confirmPassword.value;

  if (user_password !== "" && confirm_password !== "") {
    if (user_password === confirm_password) {
      message.textContent = "✅ Passwords match";
      message.style.color = "white";
    } else {
      message.textContent = "❌ Passwords do not match";
      message.style.color = "red";
    }
  } else {
    message.textContent = ""; // Clear message if either is empty
  }
};
password.addEventListener("input", checkPasswords);
confirmPassword.addEventListener("input", checkPasswords);

let password_visible = false;
let show_password_toggle = document.querySelector("#show-password-button");
show_password_toggle.addEventListener("click", () => {
  if (!password_visible) {
    show_password_toggle.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" fill="green" width="24" height="24" viewBox="0 0 1920 1920" stroke="green">
    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
    <g id="SVGRepo_iconCarrier">
      <path d="M1827.701 303.065 698.835 1431.801 92.299 825.266 0 917.564 698.835 1616.4 1919.869 395.234z" fill-rule="evenodd"/>
    </g>
  </svg>`;
    show_password_toggle.style.padding = "0px";
    password.setAttribute("type", "text");
    confirmPassword.setAttribute("type", "text");
    password_visible = true;
  } else if (password_visible) {
    show_password_toggle.innerHTML = ``;
    show_password_toggle.style.padding = "10px";
    password.setAttribute("type", "password");
    confirmPassword.setAttribute("type", "password");
    password_visible = false;
  }
});

const password_2fild = document.getElementsByClassName("no-copy");

Array.from(password_2fild).forEach((element) => {
  element.addEventListener("copy", (e) => {
    e.preventDefault();
  });
});
const error_popup_div = document.querySelector(".error-popup");
const close_popup_btn = document.querySelector("#close-popup");

const messagePopup = () => {
  error_popup_div.classList.remove("hidden");

  error_popup_div.classList.add("fade-in");

  error_popup_div.addEventListener(
    "animationend",
    () => {
      error_popup_div.classList.remove("fade-in");
    },
    { once: true }
  );
};

close_popup_btn.addEventListener("click", () => {
  error_popup_div.classList.add("hidden");
});
