<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>File Upload</title>
    <link rel="stylesheet" href="style.css" />
    <script src="script.js" defer></script>
</head>

<body>
    <header>
        <a href="/">
            <svg
                width="100px"
                height="100px"
                viewBox="0 0 32 32"
                fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <circle cx="16" cy="16" r="14" fill="#8892BF" />
                <path
                    d="M14.4392 10H16.1192L15.6444 12.5242H17.154C17.9819 12.5419 18.5986 12.7269 19.0045 13.0793C19.4184 13.4316 19.5402 14.1014 19.3698 15.0881L18.5541 19.4889H16.8497L17.6288 15.2863C17.7099 14.8457 17.6856 14.533 17.5558 14.348C17.426 14.163 17.146 14.0705 16.7158 14.0705L15.3644 14.0573L14.3661 19.4889H12.6861L14.4392 10Z"
                    fill="white" />
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M6.74092 12.5243H10.0036C10.9612 12.533 11.6552 12.8327 12.0854 13.4229C12.5156 14.0132 12.6576 14.8193 12.5115 15.8414C12.4548 16.3085 12.3289 16.7665 12.1341 17.2159C11.9474 17.6652 11.6878 18.0704 11.355 18.4317C10.9491 18.8898 10.5149 19.1805 10.0523 19.304C9.58969 19.4274 9.11076 19.489 8.61575 19.489H7.15484L6.69222 22H5L6.74092 12.5243ZM7.43485 17.9956L8.16287 14.0441H8.40879C8.49815 14.0441 8.5914 14.0396 8.6888 14.0309C9.33817 14.0221 9.87774 14.0882 10.308 14.2291C10.7462 14.37 10.8923 14.9031 10.7462 15.8282C10.5678 16.9296 10.2186 17.5727 9.69926 17.7577C9.1799 17.934 8.53053 18.0176 7.75138 18.0088H7.58094C7.53224 18.0088 7.48355 18.0043 7.43485 17.9956Z"
                    fill="white" />
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M24.4365 12.5243H21.1738L19.4329 22H21.1251L21.5878 19.489H23.0487C23.5437 19.489 24.0226 19.4274 24.4852 19.304C24.9479 19.1805 25.382 18.8898 25.7879 18.4317C26.1207 18.0704 26.3803 17.6652 26.567 17.2159C26.7618 16.7665 26.8877 16.3085 26.9444 15.8414C27.0905 14.8193 26.9486 14.0132 26.5183 13.4229C26.0881 12.8327 25.3942 12.533 24.4365 12.5243ZM22.5958 14.0441L21.8678 17.9956C21.9165 18.0043 21.9652 18.0088 22.0139 18.0088H22.1843C22.9635 18.0176 23.6128 17.934 24.1322 17.7577C24.6515 17.5727 25.0007 16.9296 25.1792 15.8282C25.3253 14.9031 25.1792 14.37 24.7409 14.2291C24.3107 14.0882 23.7711 14.0221 23.1217 14.0309C23.0243 14.0396 22.9311 14.0441 22.8417 14.0441H22.5958Z"
                    fill="white" />
            </svg>
        </a>
        <nav>
            <ul class="header-menu-ul">
                <li>
                    <a href="/learning-1--basic-concept">Basic Concept</a>
                </li>
                <li>
                    <a href="/learning-2--file-upload">File Uploads</a>
                </li>
                <li>
                    <a
                        href="/learning-3--basic-login-logout/login.php">Basic Login Logout</a>
                </li>
                <li class="l-paddingbottom-20-formobile">
                    <a
                        href="/learning-4--SQL/learning-1.sql"
                        download="Learning - 1.sql">
                        Download SQL File
                    </a>
                </li>
            </ul>
        </nav>
    </header>
    <div class="hero">
        <h1>
            This Is My Fast Website With PHP
        </h1>
        <p>
            In Here I Am Playing Around With PHP Functions. And I Am Testing It While Learning
        </p>
    </div>
    <div class="hero">
        <p>In Here I Am Playing Around With PHP Functions.
            And I Am Testing It While Learning</p>

        <p>Now I Will Be Trying to create a login system</p>

        <a href="http://localhost/fast-php-website/Learning%203%20-%20Basic%20Login%20Logout/login.php">
            <button class="btn">Login</button>
        </a>
    </div>
</body>

</html>

<?php
echo "hello";
$i = 32;

// Many concepts like do-while loops and while loops haven't been explained yet.
// This code corrects voice typing errors and clarifies key points.

// Common operators used in if statements:
// Comparison: == (equal), != or <> (not equal), === (identical), !== (not identical),
// > (greater), < (less), >= (greater or equal), <= (less or equal)
// Logical: && (AND), || (OR), ! (NOT)
// Ternary: ?: (shorthand if-else)
// Null Coalescing: ?? (first operand if set and not null, else second)

// Constants in PHP don't use the $ sign.
// Use either define() or const to declare a constant.

define("hello1", "hi"); // Using define()
const hello = "hi";     // Using const

echo hello;    // ✅ Works
echo hello1;   // ✅ Works too

// MAGIC CONSTANTS
// echo __DIR__, __FILE__;

// IF-ELSE
// The if statement runs only if the condition is true.
// else runs if the condition is false.
// elseif is used for additional conditions.

$Upantor_paul = [
    "age" => 15,
    "has_id" => true
];

// Access array values using ["key"]
// Use comparison operators like >= or <=
// && means both conditions must be true

if ($Upantor_paul["age"] >= 18 && $Upantor_paul["has_id"]) {
    echo "You can vote.";
} else {
    echo "You cannot vote.";
}

// Ternary operator (compact if-else)
$is_admin = true;
echo $is_admin ? "Welcome, Admin!" : "Access Denied";

// Using switch — useful when checking one variable against multiple values
$day = "Wednesday";
$message = "Today is";

switch ($day) {
    case "Wednesday":
        echo "<br> {$message} {$day}";
        break;
    case "Thursday":
        echo "<br> {$message} {$day}";
        break;
}

// Functions: reusable blocks of code

$user_name = "Upantor";

function greet($name)
{
    echo "<br>Great to see you, {$name}";
}

greet($user_name);

// Function: Calculator
$NUM1 = 13232313;
$operator = "/";
$NUM2 = 23;

function calculator($NUM1, $NUM2, $operator)
{
    echo "<br>";
    if ($operator === "+") {
        return $NUM1 + $NUM2;
    } elseif ($operator === "-") {
        return $NUM1 - $NUM2;
    } elseif ($operator === "*") {
        return $NUM1 * $NUM2;
    } elseif ($operator === "/") {
        return $NUM2 != 0 ? $NUM1 / $NUM2 : "Cannot divide by zero";
    } else {
        return "Invalid operator";
    }
}

echo calculator($NUM1, $NUM2, $operator);

// Even or Odd Checker
function isEvenOrOdd($number)
{
    if ($number % 2 === 0) {
        return "{$number} is an Even Number";
    } else {
        return "{$number} is an Odd Number";
    }
}
echo "<br>", isEvenOrOdd(122);

// LOOPS
// For loop
for ($i = 1; $i <= 5; $i++) {
    echo "Number: {$i} is looping <br>";
}

// While loop
$i = 1;
while ($i <= 5) {
    echo "Number: {$i} is looping <br>";
    $i++;
}

// Do-While loop
$i2 = 1;
do {
    echo "Number: {$i2} is looping <br>";
    $i2++;
} while ($i2 <= 5);

// Foreach loop (simple array)
$colors = ["red", "green", "blue"];
foreach ($colors as $color) {
    echo "Color: {$color} <br>";
}

// Associative array
$IAM = ["Name" => "Upantor Paul", "Age" => 15];
foreach ($IAM as $key => $value) {
    echo "{$key}: {$value} <br>";
}

// Another associative array
$Upantor = [
    "First Name" => "Upantor",
    "Last Name" => "Paul",
    "Full Name" => "Upantor Paul",
    "Age" => 15,
    "Country" => "Bangladesh",
    "City" => "Jessore"
];
foreach ($Upantor as $key => $value) {
    echo "{$key}: {$value} <br>";
}

// Multidimensional array
$Multidimensional_Array = [
    ["Product" => "Laptop", "Price" => 1000, "Stock" => 5],
    ["Product" => "Mouse", "Price" => 20, "Stock" => 25],
    ["Product" => "Keyboard", "Price" => 50, "Stock" => 15]
];

foreach ($Multidimensional_Array as $product) {
    echo $product["Product"] . " costs $" . $product["Price"] . "<br>" .
        "Available Stock: " . $product["Stock"] . "<br><br>";
}

// Sum prices
$total = 0;
foreach ($Multidimensional_Array as $product) {
    $total += $product["Price"];
}
echo "Total Price of All Products: $" . $total;

// Built-in Math Functions
echo "<br>", abs(-10);
echo "<br>", round(3.2323, 2);
echo "<br>", floor(23.123);

$BIF_For_Number = [1, 23, 12, 12, 2, 3, 4, 1, 5, 6, 1, 2, 5, 6, 3, 54, 45, 344, 345, 31];
echo "<br>", max($BIF_For_Number);
echo "<br>", min($BIF_For_Number);
echo "<br>", pow(max($BIF_For_Number), 2);
echo "<br>", sqrt(6561);
echo "<br>", rand(1, 100);

// Array Functions
$BIF_For_Number2 = ["God Of War", "RDR2", "GTA5"];
array_push($BIF_For_Number2, "GTA3");
array_pop($BIF_For_Number2);
print_r($BIF_For_Number2);
echo "<br>", count($BIF_For_Number2);

// Merge arrays
$My_Movies = ["RRR", "Money Heist", "Forrest Gump", "12th Fail", "3 Idiots"];
$merged = array_merge($BIF_For_Number2, $My_Movies);
print_r($merged);

// Check if a value exists in array
if (in_array("RRR", $My_Movies)) {
    echo "RRR is in My_Movies";
}

// Sort array by key
$numbe32r = [3, 43, 1, 2, 53, 0];
sort($numbe32r);
print_r($numbe32r);

// String Functions
$Build_In_Func_For_String = "Hello, World";
echo "<br>", strlen($Build_In_Func_For_String);
echo "<br>", strtoupper($Build_In_Func_For_String);
echo "<br>", strtolower($Build_In_Func_For_String);
echo "<br>", strpos($Build_In_Func_For_String, "World");
echo "<br>", str_replace("World", "Upantor", $Build_In_Func_For_String);

// File Handling
$data_file = "data.txt";
$open_file = fopen($data_file, "r");

if ($open_file) {
    $content = fread($open_file, filesize($data_file));
    echo nl2br($content);
    fclose($open_file);
} else {
    echo "<br>Unable to open the file";
}

// Simpler way
$simple_content = file_get_contents("data.txt");
echo nl2br($simple_content);

// Write to file
$file_data_2 = "data.txt";
$w_write = fopen($file_data_2, "w");

if ($w_write) {
    fwrite($w_write, "I am a new paragraph");
    fclose($w_write);
    echo "File written successfully <br>";
} else {
    echo "Error <br>";
}

// File info
if (file_exists($file_data_2)) {
    echo "File name: " . basename($file_data_2) . "<br>";
    echo "File size: " . filesize($file_data_2) . "<br>";
    echo "Last modified: " . date("F Y H:i:s", filemtime($file_data_2)) . "<br>";
    if (is_readable($file_data_2)) {
        echo "It is readable<br>";
    }
    if (is_writable($file_data_2)) {
        echo "It is writable<br>";
    }
}

// Rename file
$lorem_file = "learning_2__Lorem27.txt";
$rename_lorem_file = "lorm.txt";
if (file_exists($lorem_file)) {
    rename($lorem_file, $rename_lorem_file);
    echo "<br>File renamed successfully";
} else {
    echo "<br>Error when trying to rename the file";
}

// Delete file
$file_need_to_be_deleted = "Delete This file";
if (file_exists($file_need_to_be_deleted)) {
    unlink($file_need_to_be_deleted);
    echo "<br>File deleted successfully";
} else {
    echo "<br>Error when trying to delete the file<br><br>";
}

// Directory listing
$From_directory = "Forms";
if (is_dir($From_directory)) {
    $files = scandir($From_directory);
    foreach ($files as $file) {
        if ($file !== "." && $file !== "..") {
            echo "File: $file<br>";
        }
    }
}

echo '
<main>
    <div>
        <input type="text" id="username">
        <button id="username-submit">Submit</button>
    </div>
</main>';

// Cookies in PHP
// setcookie("username", "Upantor", time() + 3600);

if (isset($_COOKIE['username'])) {
    echo "Hello " . ucwords($_COOKIE['username']);
} else {
    echo "Hello Guest";
}

// Cookie format: name, value, then optional settings
setcookie(
    "ID",
    "d2",
    time() + 3600,
    "fast-php-website/",
    "localhost",
    true,
    false
);

// Delete cookie
setcookie(
    "ID",
    "",
    time() - 3600,
    "fast-php-website/",
    "localhost",
    true,
    true
);

// Sessions in PHP
// Sessions store user data on the server
session_start();
$_SESSION["username"] = "Upantor Paul";
echo $_SESSION["username"]; // Echo session value

?>