<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="style.css">
    <script src="script.js" defer></script>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Fredoka:wght@300..700&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto+Condensed:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet" />
</head>

<body>
    <header>
        <a href="/fast-php-website/">
            <svg
                width="100px"
                height="100px"
                viewBox="0 0 32 32"
                fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <circle cx="16" cy="16" r="14" fill="#8892BF" />
                <path
                    d="M14.4392 10H16.1192L15.6444 12.5242H17.154C17.9819 12.5419 18.5986 12.7269 19.0045 13.0793C19.4184 13.4316 19.5402 14.1014 19.3698 15.0881L18.5541 19.4889H16.8497L17.6288 15.2863C17.7099 14.8457 17.6856 14.533 17.5558 14.348C17.426 14.163 17.146 14.0705 16.7158 14.0705L15.3644 14.0573L14.3661 19.4889H12.6861L14.4392 10Z"
                    fill="white" />
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M6.74092 12.5243H10.0036C10.9612 12.533 11.6552 12.8327 12.0854 13.4229C12.5156 14.0132 12.6576 14.8193 12.5115 15.8414C12.4548 16.3085 12.3289 16.7665 12.1341 17.2159C11.9474 17.6652 11.6878 18.0704 11.355 18.4317C10.9491 18.8898 10.5149 19.1805 10.0523 19.304C9.58969 19.4274 9.11076 19.489 8.61575 19.489H7.15484L6.69222 22H5L6.74092 12.5243ZM7.43485 17.9956L8.16287 14.0441H8.40879C8.49815 14.0441 8.5914 14.0396 8.6888 14.0309C9.33817 14.0221 9.87774 14.0882 10.308 14.2291C10.7462 14.37 10.8923 14.9031 10.7462 15.8282C10.5678 16.9296 10.2186 17.5727 9.69926 17.7577C9.1799 17.934 8.53053 18.0176 7.75138 18.0088H7.58094C7.53224 18.0088 7.48355 18.0043 7.43485 17.9956Z"
                    fill="white" />
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M24.4365 12.5243H21.1738L19.4329 22H21.1251L21.5878 19.489H23.0487C23.5437 19.489 24.0226 19.4274 24.4852 19.304C24.9479 19.1805 25.382 18.8898 25.7879 18.4317C26.1207 18.0704 26.3803 17.6652 26.567 17.2159C26.7618 16.7665 26.8877 16.3085 26.9444 15.8414C27.0905 14.8193 26.9486 14.0132 26.5183 13.4229C26.0881 12.8327 25.3942 12.533 24.4365 12.5243ZM22.5958 14.0441L21.8678 17.9956C21.9165 18.0043 21.9652 18.0088 22.0139 18.0088H22.1843C22.9635 18.0176 23.6128 17.934 24.1322 17.7577C24.6515 17.5727 25.0007 16.9296 25.1792 15.8282C25.3253 14.9031 25.1792 14.37 24.7409 14.2291C24.3107 14.0882 23.7711 14.0221 23.1217 14.0309C23.0243 14.0396 22.9311 14.0441 22.8417 14.0441H22.5958Z"
                    fill="white" />
            </svg>
        </a>
        <nav>
            <svg
                class="header-mobile-icon l-tabletpc-hidden"
                xmlns="http://www.w3.org/2000/svg"
                width="50px"
                height="50px"
                viewBox="0 0 24 24"
                fill="none">
                <path
                    d="M4 6H20M4 12H20M4 18H20"
                    stroke="#000000"
                    stroke-width="2"
                    stroke-linecap="round"
                    stroke-linejoin="round" />
            </svg>

            <ul class="header-menu-ul">
                <li>
                    <a href="/learning-1--basic-concept">Basic Concept</a>
                </li>
                <li>
                    <a href="/learning-2--file-upload">File Uploads</a>
                </li>
                <li>
                    <a
                        href="/learning-3--basic-login-logout/login.php">Basic Login Logout</a>
                </li>
                <li class="l-paddingbottom-20-formobile">
                    <a
                        href="/learning-4--SQL/learning-1.sql"
                        download="Learning - 1.sql">
                        Download SQL File
                    </a>
                </li>
            </ul>
        </nav>
    </header>

    <?php
    // ==============================
    // Single File Upload
    // ==============================

    if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES['file']) && $_FILES['file']['error'] !== 4) {
        // Check if file uploaded without error
        if ($_FILES["file"]["error"] === 0) {
            echo '<p class="p-style1">Getting your file...</p>';

            // Set upload directory
            $uploaddir = "F:\\Coding\\PHP\\Xampp\\htdocs\\fast-php-website\\file-upload\\uploads\\";

            // Get file details
            $file_name   = basename($_FILES["file"]["name"]);
            $target_file = $uploaddir . $file_name;
            $file_type   = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
            $file_size   = $_FILES["file"]["size"];

            // Allowed file extensions
            $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];

            // Check if file type is allowed
            if (in_array($file_type, $allowed_types)) {

                // Check if file size is less than 1 MB
                if ($file_size < 1e+6) {

                    // Try to move uploaded file to target directory
                    if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                        echo "The file <strong>$file_name</strong> has been uploaded to <code>$uploaddir</code>.";
                    } else {
                        echo '<p class="p-style1">Oops, something went wrong while moving the file.</p>';
                    }
                } else {
                    echo '<p class="p-style1">Max upload size is 1 MB</p>';
                }
            } else {
                echo "Only jpg, jpeg, png, and gif file types are allowed.";
            }
        } else {
            echo '<p class="p-style1">Error uploading file. Code: ' . $_FILES["file"]["error"] . '</p>';
        }
    } else {
        echo '<p class="p-style1">Please upload a file.</p>';
    }


    // ==============================
    // Multiple File Upload
    // ==============================

    if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES['file-multiple'])) {
        // Set upload directory
        $uploaddir2 = "F:\\Coding\\PHP\\Xampp\\htdocs\\fast-php-website\\file-upload\\uploads\\";

        // Allowed file extensions
        $allowed_types2 = ['jpg', 'jpeg', 'png', 'gif'];

        // Prepare arrays from $_FILES
        $errors     = is_array($_FILES['file-multiple']['error'])     ? $_FILES['file-multiple']['error']     : [$_FILES['file-multiple']['error']];
        $names      = is_array($_FILES['file-multiple']['name'])      ? $_FILES['file-multiple']['name']      : [$_FILES['file-multiple']['name']];
        $tmp_names  = is_array($_FILES['file-multiple']['tmp_name'])  ? $_FILES['file-multiple']['tmp_name']  : [$_FILES['file-multiple']['tmp_name']];
        $sizes      = is_array($_FILES['file-multiple']['size'])      ? $_FILES['file-multiple']['size']      : [$_FILES['file-multiple']['size']];

        // Loop through all uploaded files
        foreach ($names as $key => $file_name) {
            // Only handle files with no error
            if ($errors[$key] === 0) {
                $file_name2 = basename($file_name);
                $file_type2 = strtolower(pathinfo($file_name2, PATHINFO_EXTENSION));

                // Check if file type is allowed
                if (in_array($file_type2, $allowed_types2)) {

                    // Check if file size is less than 1 MB
                    if ($sizes[$key] < 1e+6) {
                        // Generate a unique name for the uploaded file to avoid overwriting
                        $new_name = uniqid("upload_", true) . "." . $file_type2;

                        // Move the file to upload directory
                        if (move_uploaded_file($tmp_names[$key], $uploaddir2 . $new_name)) {
                            echo "The file '$file_name' has been successfully uploaded as '$new_name' to '$uploaddir2'<br>";
                        } else {
                            echo "Error uploading the file '$file_name'.<br>";
                        }
                    } else {
                        echo "Sorry, the file '$file_name' was not uploaded because it is more than 1MB.<br>";
                    }
                } else {
                    echo "Sorry, file type '$file_type2' is not allowed. Your file '$file_name' must be jpg, jpeg, png, or gif.<br>";
                }
            } else {
                // Show error code if file failed before reaching this point
                echo "Upload error code {$errors[$key]} for file '$file_name'.<br>";
            }
        }
    }



    // ----------------------------------------------
    // 📁 PHP File Upload Process - Quick Reference
    // ----------------------------------------------

    // 1️⃣ Form Submission:
    // User selects file → submits form via POST.
    // Browser sends file as part of $_FILES.

    // 2️⃣ Access Temporary File:
    // Temp path: $_FILES['file']['tmp_name']

    // 3️⃣ Move to Permanent Location:
    // move_uploaded_file($_FILES['file']['tmp_name'], 'uploads/' . $_FILES['file']['name']);

    // Temp file auto-deletes after script ends.

    // 🛠️ Example:
    // image.jpg → temp: /tmp/phpYzdqkD → moved to uploads/image.jpg

    // ----------------------------------------------
    // 🛠️ php.ini Settings for Large File Uploads:
    // ----------------------------------------------
    /*
upload_max_filesize = 100M       // Max upload size
post_max_size = 128M            // Total POST size limit
max_execution_time = 300        // Max script run time
max_input_time = 300            // Time to parse input
memory_limit = 256M             // Memory allocated to script
max_file_uploads = 20           // Max files per request
upload_tmp_dir = "/path/to/tmp" // Optional custom temp dir
*/

    // ----------------------------------------------
    // 🔒 Security Best Practices:
    // ----------------------------------------------
    // ✔️ Validate file type (mime_content_type or extension)
    // ✔️ Limit file size via php.ini and in script
    // ✔️ Rename uploaded files before saving
    // ✔️ Store files in a non-public directory
    // ✔️ Block dangerous extensions like .php, .exe, etc.

    // ----------------------------------------------


    ?>