-- Create a new database
CREATE DATABASE my_database;

--This is how we can drop database
DROP DATABASE test;

---------This this how we can crate TABLE
CREATE TABLE orders (
    order_id INT PRIMARY KEY AUTO_INCREMENT,
    --INT is a data type that stores whole numbers (no decimals).
    user_id INT,
    porduct VARCHAR(50),
    --VARCHAR(n) is a data type that stores text up to n characters in length.
    FOREIGN KEY (user_id) REFERENCES users(id) -- FOREIGN KEY creates a link between two tables to maintain data consistency.
    -- REFERENCES tells which table and column the foreign key is pointing to.
);

-- This is how we can select data from a table
SELECT
    *
FROM
    `users`
WHERE
    id = 1;

-- Shows the user whose ID is 1
-- This is the structure of an INSERT query.
-- After writing it, it looks like this:
INSERT INTO
    `users`(`id`, `username`, `email`, `created_at`)
VALUES
    (
        '[value-1]',
        -- Example: 1
        '[value-2]',
        -- Example: upantor
        '[value-3]',
        -- Example: upantor81@gmail.com
        '[value-4]' -- Example: 2025-07-24 10:30:00
    );

-- In most databases, the `id` is set to AUTO_INCREMENT
-- So it will automatically go up and always be unique
-- That means we don’t have to manually insert `id` every time
INSERT INTO
    users (username, email)
VALUES
    ('test 1', 'upantor81@gmail.com');

-- This is how we can delete a specific row
-- This will delete the user where the ID is 2
DELETE FROM
    users
WHERE
    id = 2;

-- This is how we can create multiple users in one go
-- It's called bulk insert and is useful for adding test data
INSERT INTO
    users (username, email)
VALUES
    ('user1', 'user1@example.com'),
    ('user2', 'user2@example.com'),
    ('user3', 'user3@example.com'),
    ('user4', 'user4@example.com'),
    ('user5', 'user5@example.com'),
    ('user6', 'user6@example.com'),
    ('user7', 'user7@example.com'),
    ('user8', 'user8@example.com'),
    ('user9', 'user9@example.com'),
    ('user10', 'user10@example.com'),
    ('user11', 'user11@example.com'),
    ('user12', 'user12@example.com'),
    ('user13', 'user13@example.com'),
    ('user14', 'user14@example.com'),
    ('user15', 'user15@example.com'),
    ('user16', 'user16@example.com'),
    ('user17', 'user17@example.com');

/******** Some SQL functions ********/
-- Some advanced versions of SELECT
-- ORDER BY is used to sort the data by a specific column
-- ASC = ascending (A to Z), DESC = descending (Z to A)
SELECT
    *
FROM
    users
ORDER BY
    created_at ASC;

-- Sorts by creation time from oldest to newest
-- This is a combination of ORDER BY and LIMIT
-- LIMIT is a new function that limits the output rows
SELECT
    *
FROM
    `users`
ORDER BY
    username ASC
LIMIT
    2;

-- Only shows the first 2 users sorted by name (A to Z)
-- COUNT(*) counts the total number of rows in a table
-- AS total_users gives that number a label
SELECT
    COUNT(*) AS total_users
FROM
    users;

--In the code blow The AVG takes out the average of what ever it is
SELECT
    AVG(id) as average_id
FROM
    users;

--This is how we can set the autoimment
ALTER TABLE
    users AUTO_INCREMENT = 1;

--When we need to compare with null we need to use is or is not in SQL
DELETE FROM
    orders
WHERE
    user_id IS NULL;

/*We are retrieving data from two tables: users and orders. Specifically:
 From the users table, we select the username column.
 From the orders table, we select the product column.
 
 We use an INNER JOIN to combine the rows of both 
 tables only when the id in the users table matches 
 the user_id in the orders table. 
 This ensures we get records only for users who have placed orders.
 */
SELECT
    users.username,
    orders.product
FROM
    users
    INNER JOIN orders ON users.id = orders.user_id;

----let me explain some sql keyword
CREATE TABLE users (
    -- INT: stores whole numbers
    -- UNSIGNED: number must be 0 or higher (no negatives)
    -- AUTO_INCREMENT: automatically increases by 1 for each new row
    -- PRIMARY KEY: each row has a unique ID
    id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    -- VARCHAR: stores string values, (50) can store up to 50 characters
    -- NOT NULL: value is required, cannot be empty
    -- UNIQUE: every value must be different
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    -- TIMESTAMP: stores date and time
    -- DEFAULT CURRENT_TIMESTAMP: automatically sets current date & time when a new row is added
    reg_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);